#include <iostream>
#include <algorithm>
#include <vector>
#include <map>
#include <fstream>
#define f first
#define s second
using namespace std;
typedef pair<int, int> pii;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    ifstream fin ("ydata-ysm-advertiser-bids-v1_0.txt");
    string useless;

    //set id on each item and agent for easy access
    map<int, int> mp_agent, mp_item;
    int id_agent = 0, id_item = 0;

    //records the bid of each advertiser on the advertisements
    map<pii, double> bid;
    int cnt = 0;

    //read data
    while(fin >> useless){
        fin >> useless;
        int item, agent; double price;
        fin >> item >> agent >> price;
        fin >> useless;
        if (! mp_agent.count(agent)){
            mp_agent[agent] = id_agent ++;
        }
        if (! mp_item.count(item)){
            mp_item[item] = id_item ++;
        }
        bid[make_pair(mp_agent[agent], mp_item[item])] = price;
        cnt ++;
        if (cnt > 1e7) break;
    }

    int n = 10, m = 20;
    vector<vector<double>> value(n, vector<double>(m));
    int ind = 0;

    for (int i = 0; i < id_agent; i ++){
        int cc = 0;
        for (int j = 0; j < n; j ++){
            if (bid[make_pair(i, j)] == 0) cc ++;
        }

        //exclude agents who have no bid on most advertisements of interest
        if (cc <= 5){
            for (int j = 0; j < n; j ++){
                value[j][ind] = bid[make_pair(i, j)];
            }
            ind ++;
            if (ind == m) break;
        }

    }
    
    //output valuation; take the last 6 advertisements
    done: cout << '[';
    for (int i = 4; i < n; i ++){
        cout << '[';
        for (int j = 0; j < m; j ++){
            if (j != m - 1) cout << value[i][j] << ", ";
            else cout << value[i][j];
        }
        if (i != n - 1) cout << "], " << endl;
        else cout << ']';
    }
    cout << ']' << endl;
}